<?php

namespace App\Http\Requests\Admin\Categories;

use App\Models\Setting;
use Illuminate\Foundation\Http\FormRequest;

class CategoryStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        $rules = [
            'parent_id' => 'nullable',
        ];
        // Append language-specific validation rules
        $languages = json_decode(Setting::pull('languages'));
        foreach ($languages as $language) {
            $langCode = $language->code;
            $rules[$langCode.'_title'] = 'required|max:255|unique:category_contents,title';
        }

        return $rules;
    }
}
