import Accordion from "../Accordion"

export default function Faq4({ data }) {
    const { section_title, section_subtitle, image_url, rotate_image_url, faq_list } = data
    return (
        <div className="container">
            {(section_subtitle || section_title) && (
                <>
                    <div className="cs_section_heading cs_style_1">
                        {section_subtitle && (
                            <>
                                <h3
                                    className="cs_section_subtitle text-uppercase cs_accent_color cs_semibold m-0 cs_accent_color cs_fs_32"
                                    dangerouslySetInnerHTML={{
                                        __html: section_subtitle
                                    }}
                                />
                                <div className="cs_height_5"></div>
                            </>
                        )}
                        {section_title && (
                            <h2
                                className="cs_section_title cs_fs_72 m-0"
                                dangerouslySetInnerHTML={{
                                    __html: section_title
                                }}
                            />
                        )}
                    </div>
                    <div className="cs_height_72 cs_height_lg_45"></div>
                </>
            )}
            <div className="row cs_gap_y_40">
                <div className="col-xl-8">
                    <Accordion
                        arrowStyle={2}
                        accordionData={faq_list}
                        variant="cs_accordians cs_style1 cs_type_3 cs_heading_color"
                    />
                </div>
                <div className="col-xl-4">
                    <div className="cs_about cs_style_1 cs_type_2">
                        <div className="cs_about_img">
                            {image_url && <img src={image_url} alt="About" className="w-100" />}
                            {rotate_image_url && (
                                <div className="cs_about_mini_img">
                                    <img src={rotate_image_url} alt="Spening" className="cs_rotate_animation" />
                                    <svg
                                        className="cs_right_icon cs_accent_color"
                                        width={48}
                                        height={48}
                                        viewBox="0 0 48 48"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M29.3595 19.5412L22.1437 26.353L18.6807 22.7922C18.2968 22.3971 17.6646 22.3881 17.2697 22.7718C16.8745 23.1559 16.8655 23.7874 17.2494 24.1824L21.4029 28.4439C21.7887 28.8319 22.4123 28.8452 22.8142 28.4736L30.7509 20.9916C30.9436 20.8099 31.0562 20.559 31.0637 20.2945C31.0711 20.03 30.973 19.7733 30.7908 19.581C30.4045 19.1797 29.7677 19.1621 29.3595 19.5412Z"
                                            fill="currentColor"
                                        />
                                        <path
                                            d="M24.0048 9.05786C15.7581 9.05786 9.05249 15.7599 9.05249 24.0023C9.05249 32.2451 15.7581 38.9472 24.0048 38.9472C32.2519 38.9472 38.9575 32.2451 38.9575 24.0023C38.9575 15.7599 32.2519 9.05786 24.0048 9.05786ZM24.0048 36.9466C16.859 36.9466 11.0542 31.1346 11.0542 24.0023C11.0542 16.87 16.859 11.0585 24.0048 11.0585C31.1576 11.0585 36.9558 16.8536 36.9558 24.0023C36.9558 31.151 31.1576 36.9466 24.0048 36.9466Z"
                                            fill="currentColor"
                                        />
                                        <path
                                            d="M44.5822 18.5007L44.9126 12.5688C44.9356 12.1707 44.719 11.7967 44.3621 11.6185L39.0776 8.94779L36.4055 3.66608C36.2237 3.31245 35.8519 3.09715 35.4547 3.11591L29.5095 3.43632L24.5553 0.164992C24.2215 -0.0549975 23.7887 -0.0549975 23.4544 0.164992L18.5003 3.43632L12.5657 3.10614C12.1669 3.08269 11.7931 3.29917 11.6149 3.65631L8.94232 8.93802L3.65823 11.6088C3.30403 11.7901 3.089 12.1617 3.10777 12.5591L3.43773 18.491L0.165079 23.4425C-0.0550264 23.7762 -0.0550264 24.2088 0.165079 24.5428L3.42796 29.5041L3.0976 35.4361C3.07454 35.8342 3.29073 36.2082 3.64806 36.3864L8.93255 39.0571L11.6047 44.3388C11.7861 44.6928 12.1579 44.9077 12.5555 44.889L18.4905 44.5588L23.4447 47.8297C23.7766 48.0568 24.2137 48.0568 24.5456 47.8297L29.4997 44.5588L35.4347 44.889C35.8331 44.912 36.2069 44.6956 36.3855 44.3388L39.0577 39.0571L44.3422 36.3864C44.696 36.2047 44.9114 35.8334 44.8926 35.4361L44.5623 29.5041L47.8349 24.5526C48.055 24.2189 48.055 23.786 47.8349 23.4523L44.5822 18.5007ZM42.7205 28.684C42.5985 28.8629 42.5418 29.0782 42.5606 29.2943L42.8706 34.9058L37.8766 37.4265C37.6862 37.5219 37.5318 37.6766 37.4364 37.8669L34.914 42.8583L29.2995 42.5484C29.0845 42.5406 28.8722 42.5961 28.6889 42.7082L24.0049 45.7994L19.3213 42.7082C19.1587 42.5984 18.9671 42.539 18.7708 42.5383H18.7208L13.106 42.8485L10.5839 37.8567C10.4885 37.6664 10.3341 37.5121 10.1433 37.4167L5.13915 34.9058L5.44957 29.2943C5.45738 29.0794 5.40148 28.8672 5.28928 28.684L2.19685 24.0024L5.28928 19.3209C5.41164 19.1423 5.46833 18.9267 5.44957 18.711L5.13915 13.0991L10.1336 10.5784C10.3239 10.483 10.4784 10.3287 10.5738 10.1384L13.0958 5.14661L18.7106 5.45686C18.9253 5.46429 19.1375 5.4088 19.3213 5.29666L24.0049 2.20586L28.6889 5.29666C28.8679 5.41896 29.0837 5.47562 29.2995 5.45686L34.914 5.14661L37.4364 10.1384C37.5318 10.3287 37.6862 10.483 37.8766 10.5784L42.8706 13.0991L42.5606 18.711C42.5528 18.9255 42.6087 19.1377 42.7205 19.3209L45.8133 24.0024L42.7205 28.684Z"
                                            fill="currentColor"
                                        />
                                    </svg>
                                </div>
                            )}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    )
}
